<?php
// Include database connection
include 'connection.php';

// Fetch data from the database
$sql = "SELECT * FROM fees_amounts ORDER BY id DESC";
$result = mysqli_query($con, $sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Fees Records</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" />
    <!-- Custom Styles -->
    <style>
        body {
            background-color: #f8f9fa;
        }
        .table-container {
            margin-top: 50px;
        }
        .table th {
            background-color: #007bff;
            color: white;
        }
        footer {
            margin-top: 30px;
            text-align: center;
            padding: 10px;
            background-color: #007bff;
            color: white;
            position: fixed;
            width: 100%;
            bottom: 0;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="#">Fee Management System</a>
            <a href="admin_fees_amount.php" class="btn btn-success">Post Fees Amount</a>
        </div>
    </nav>

    <!-- Table Container -->
    <div class="container table-container">
        <div class="card shadow">
            <div class="card-header bg-primary text-white text-center">
                <h4>Fees Records</h4>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Class</th>
                            <th>Tuition Fee</th>
                            <th>Other Fees</th>
                            <th>Created At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if (mysqli_num_rows($result) > 0) {
                            $count = 1;
                            while ($row = mysqli_fetch_assoc($result)) {
                                echo "<tr>";
                                echo "<td>" . $count++ . "</td>";
                                echo "<td>" . $row['class'] . "</td>";
                                echo "<td>TZS " . number_format($row['tuition_fee'], 2) . "</td>";
                                echo "<td>TZS " . number_format($row['other_fee'], 2) . "</td>";
                                echo "<td>" . date('d M Y, h:i A', strtotime($row['created_at'])) . "</td>";
                                echo "<td>
                                    <a href='edit_fees_amount.php?id=" . $row['id'] . "' class='btn btn-warning btn-sm'>Edit</a>
                                    <a href='delete_fees_amount.php?id=" . $row['id'] . "' 
                                       class='btn btn-danger btn-sm' 
                                       onclick='return confirm(\"Are you sure you want to delete this record?\");'>
                                       Delete
                                    </a>
                                  </td>";
                                echo "</tr>";
                            }
                        } else {
                            echo "<tr><td colspan='6' class='text-center'>No records found</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer>
        <p>&copy; <?php echo date('Y'); ?> Fee Management System. All Rights Reserved.</p>
    </footer>
</body>
</html>

<?php
// Close connection
mysqli_close($con);
?>
